initParticles = function() {
    try {
        var particles = $(".background-particles"),
            pLnt = particles.length;

        if (pLnt > 0) {
            var particlesIds = 1;
            var parseParticles = function () {
                var obj = $(this);

                obj.attr("id", "psjs-" + particlesIds);
                particlesJS.load("psjs-" + particlesIds, obj.attr("data-path"));

                particlesIds++;
            };

            particles.each(parseParticles);
        }

    } catch (e) {
        getStack(0, e);
    }
}

initSliders = function() {
	var bgs = $(".background-slider:not(.__done)");

	if (!bgs.length){
		return true;
	}

	bgs.each(function() {

		var bg			= $(this),
			images		= JSON.parse(bg.attr("data-images")),
			trans		= bg.attr("data-transition"),
			transDur	= bg.attr("data-traisition-duration"),
			duration	= bg.attr("data-duration");
		
		bg.backstretch(
			images, 
			{
				transition			: trans , 
				transitionDuration	: transDur, 
				duration			: duration
			}
		);			

		bg.addClass("__done");

	});
}

initYoutube = function() {
	var bgs = $(".background-youtube:not(.__done)");

	if (!bgs.length){
		return true;
	}

	bgs.each(function() {
		var bg			= $(this),
			container	= $(this).find(".background-youtube-content"),
			youtube		= bg.attr("data-video"),
			startPoint	= bg.attr("data-start"),
			volume		= bg.attr("data-volume");

		container.YTPlayer({
			videoId			: youtube,
			fitToBackground	: true,
			mute			: false,
			playerVars		: {
				modestbranding	: 0,
				autoplay		: 1,
				controls		: 0,
				showinfo		: 0,
				branding		: 0,
				rel				: 0,
				autohide		: 0,
				start			: startPoint
			},
			callback: function() {
				var player = container.data('ytPlayer').player;				
				player.setVolume(volume);
			}
		});
		bg.addClass("__done");
	});

}



$(document).ready(initParticles);
$(document).ready(initYoutube);
$(document).ready(initSliders);